/**
 * Custom scripts needed for the colorpicker, image button selectors,
 * and navigation tabs.
 */

jQuery(document).ready(function($) {

	// Loads the color pickers
	$('.of-color').wpColorPicker();

	// Image Options
	$('.of-radio-img-img').click(function(){
		$(this).parent().parent().find('.of-radio-img-img').removeClass('of-radio-img-selected');
		$(this).addClass('of-radio-img-selected');
	});

	$('.of-radio-img-label').hide();
	$('.of-radio-img-img').show();
	$('.of-radio-img-radio').hide();

	// Loads tabbed sections if they exist
	if ( $('.nav-tab-wrapper').length > 0 ) {
		options_framework_tabs();
	}

	function options_framework_tabs() {

		var $group = $('.group'),
			$navtabs = $('.nav-tab-wrapper li a'),
			active_tab = '';

		// Hides all the .group sections to start
		$group.hide();
		$('.nav-tab-wrapper li').removeClass('active');

		// Find if a selected tab is saved in localStorage
		if ( typeof(localStorage) != 'undefined' ) {
			active_tab = localStorage.getItem('active_tab');
		}

		// If active tab is saved and exists, load it's .group
		if ( active_tab != '' && $(active_tab).length ) {
			$(active_tab).fadeIn();
			$(active_tab + '-tab').parent('li').addClass('active');
		} else {
			$('.group:first').fadeIn();
			$('.nav-tab-wrapper li:first').addClass('active');
		}

		// Bind tabs clicks
		$navtabs.click(function(e) {

			e.preventDefault();

			$('.nav-tab-wrapper li').removeClass('active');

			$(this).parent('li').addClass('active');
			$(this).blur();

			if (typeof(localStorage) != 'undefined' ) {
				localStorage.setItem('active_tab', $(this).attr('href') );
			}

			var selected = $(this).attr('href');

			$group.hide();
			$(selected).fadeIn();

		});
	}

	var $search = $('#of-search-input');
	if ($search.length) {
		function normalize(s){return (s||'').toLowerCase();}
		function fuzzyMatch(q, text){
			q = normalize(q);
			text = normalize(text);
			if (!q) return true;
			if (text.indexOf(q) !== -1) return true;
			var i=0,j=0;
			while (i<q.length && j<text.length){
				if (q.charCodeAt(i) === text.charCodeAt(j)) i++;
				j++;
			}
			return i===q.length;
		}
		function restoreTabs(){
			var $groups = $('.group');
			var href = $('.nav-tab-wrapper li.active a').attr('href') || $('.nav-tab-wrapper li a').first().attr('href');
			$groups.hide();
			if (href) $(href).fadeIn();
			$('.group .section').show();
		}
		function applySearch(){
			var q = $search.val().trim();
			var $groups = $('.group');
			if (!q){
				restoreTabs();
				return;
			}
			$groups.show();
			$('.nav-tab-wrapper li').removeClass('active');
			$('.group .section').each(function(){
				var $s = $(this);
				var name = $s.find('h4.heading').text();
				var gidText = $s.closest('.group').find('.boxmoe_tab_header').first().text();
				var hay = (name||'') + ' ' + (gidText||'');
				if (fuzzyMatch(q, hay)){
					$s.show();
				} else {
					$s.hide();
				}
			});
			$groups.each(function(){
				var $g = $(this);
				if ($g.find('.section:visible').length === 0){
					$g.hide();
				} else {
					$g.show();
				}
			});
		}
		$search.on('input', applySearch);
	}

});
